-- Run AE Installer
-- for Anniversary Edition Seven
-- by Iritscen
-- Serves as a forking alias which opens either the AE Installer, or, if the AEI is
--	not found, the AEI Updater so it can install the Installer. Used as both a
--	shortcut for the user and as a part of the AE Setup process.
-- History:
--   1.0.7 - Now an AppleScriptObjC application to ensure signing integrity and OS
--              compatibility for 10.6 through 10.11.
--   1.0.6 - The previous method fails sometimes, e.g. in 10.7 with Apple Java
--              installed, so now we are just looking in either place and calling Java
--              when we find it.
--   1.0.5 - Removing "which java" as "smart" method for finding Java, as it can now
--              return a value like "/usr/bin/java" even when Java is not really
--              there; now calling Java using a fixed path for 10.6 and another fixed
--              path for 10.7+.
--   1.0.4 - Calling Java through command-line again before falling back to Internet
--              Plug-Ins location, to restore 10.6 compatibility.
--   1.0.3 - Instead of escaping only space characters in paths, put paths in quotes
--              to avoid need for escaping entirely.
--   1.0.2 - Calling Java at Internet plug-in location instead of using basic command-
--              line "java", as only the JDK installs command-line Java.
--   1.0.1 - Now setting environment to UTF-8 in order to avoid 'ƒ' problem in Java 7.
--   1.0   - Initial release.

script AppDelegate
	property parent : class "NSObject"
    global parentPathUnixNS
    global parentPathUnixStr
    global parentPathASAlias
    global parentPathASStr
	
	-- IBOutlets
	property theWindow : missing value
	
	on applicationWillFinishLaunching_(aNotification)
        tell application "Finder"
            tell current application's class "NSBundle"
                tell its mainBundle()
                    set parentPathUnixNS to bundlePath()'s stringByDeletingLastPathComponent
                    set parentPathUnixStr to parentPathUnixNS as string
                end tell
            end tell
            set parentPathASAlias to POSIX file parentPathUnixStr as alias
            set parentPathASStr to parentPathASAlias as string
            set success to true
            
            -- Test for Java at the two standard locations
            set javaPath to "/Library/Internet\\ Plug-Ins/JavaAppletPlugin.plugin/Contents/Home/bin/java"
            set javaExistsTest to ("if [ -f " & javaPath & " ]; then echo okay; fi") as string
            set javaExists to do shell script javaExistsTest without altering line endings
            if (javaExists is "") then
                -- Test for Java at old location (Apple Java)
                set javaPath to "/usr/bin/java"
                set javaExistsTest to ("if [ -f " & javaPath & " ]; then echo okay; fi") as string
                set javaExists to do shell script javaExistsTest without altering line endings
                if (javaExists is "") then
                    display alert "Could not find Java!"
                    set success to false
                end if
            end if
            
            if (success is true) then
                set AEIUfolder to parentPathASStr & "AEInstaller"
                set AEIU to AEIUfolder & ":AEInstaller2Updater.jar"
                set AEIU_CLI to POSIX path of AEIU
                set run_AEIU to "export LC_CTYPE=\"UTF-8\";" & javaPath & " -jar \"" & AEIU_CLI & "\" &> /dev/null &"
                
                set AEIfolder to parentPathASStr & "AEInstaller:bin"
                set AEI to AEIfolder & ":AEInstaller2.jar"
                set AEI_CLI to POSIX path of AEI
                set run_AEI to "export LC_CTYPE=\"UTF-8\";" & javaPath & " -jar \"" & AEI_CLI & "\" &> /dev/null &"
                if not (parentPathUnixNS's lastPathComponent as string is "AE") then
                    display alert "Please put \"Run AE Installer\" in the AE/ folder so I can find the Installer."
                else if (AEI exists) then
                    do shell script run_AEI
                else if (AEIU exists) then
                    do shell script run_AEIU
                else
                    display alert "Could not find AE Installer *or* AE Installer Updater! You may need to re-install the AE."
                end if
            end if
        end tell
        tell me
            quit
        end tell
	end applicationWillFinishLaunching_
	
	on applicationShouldTerminate_(sender)
		-- Insert code here to do any housekeeping before your application quits 
		return current application's NSTerminateNow
	end applicationShouldTerminate_
	
end script